/*
g++ binScramblefloat.cpp memAllocation.cpp -o binScramblefloat
Usage:binscramblefloat infile.bin(input data) scrambledfile.bin(output file) size(no. of examples) s(features)
Example: binscramblefloat iris.bin siris.bin 150 4
*/



#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/times.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/resource.h>
#include "memheader.h"

typedef float D_TYPE;		//type of binary data to read and write
long int MAXDATA, s, SIZE;	//parameters of data to be supplied by command line arguments




#define D_SIZE sizeof(D_TYPE)
char t_s[180];
D_TYPE **X;			//pointer to allocate memory to keep data set in a 2D matrix
D_TYPE *buff;			//pointer to allocate memory to load data in a 1D matrix 
main (int argc, char *argv[])
{
  char ch;
  int i, j, *index, tmp, rno1, rno2;

  MAXDATA = atoi (argv[3]);	//no of examples 
  s = atoi (argv[4]);		//dimension
  SIZE = MAXDATA * s;		//total size 
  printf ("\ninfile=%s outfile=%s examples=%d s=%d\n", argv[1], argv[2],
	  MAXDATA, s);

  allocate2Dfloat (&X, MAXDATA, s);	//dynamic memory allocated for data set
  allocate1Dfloat (&buff, SIZE);	//dynamic memory allocated for a record
  allocate1Dint (&index, MAXDATA);	//memory allocated to store index of examples; index will be scrambled to generate a random permutation

  FILE *ptr, *v_center;

  srand (100);			//random seed here
  srand48 (200);		//random seed here
  for (i = 0; i < MAXDATA; i++)	//initial index of examples as it loaded
    index[i] = i;

  for (i = 0; i < MAXDATA * 2; i++)	//index randomly scrambled;  
    {
      rno1 = lrand48 () % MAXDATA;
      rno2 = lrand48 () % MAXDATA;
      tmp = index[rno1];	//swapping randomly selected index
      index[rno1] = index[rno2];
      index[rno2] = tmp;
    }
//binary input data loaded 
  ptr = fopen (argv[1], "rb");
  fread (buff, D_SIZE, SIZE, ptr);
  fclose (ptr);

//stored in a 2 dimension array
  for (i = 0; i < MAXDATA; i++)
    for (j = 0; j < s; j++)
      X[i][j] = buff[i * s + j];
  if (0)			//for debugging
    {
      for (i = 0; i < MAXDATA; i++)
	{
	  for (j = 0; j < s; j++)
	    printf ("%f ", X[i][j]);
	  printf ("\n");
	}
    }

//

/*
FILE *ind;
ind=fopen("index.dat","w");
fprintf(ind,"\nMapped Original\n");
*/
//scrambled data to be written to output file

  ptr = fopen (argv[2], "wb");
  for (i = 0; i < MAXDATA; i++)
    {
      for (j = 0; j < s; j++)
	buff[j] = X[index[i]][j];

      fwrite (buff, D_SIZE, s, ptr);

//fprintf(ind,"%d %d\n",i+1,index[i]+1);
    }
  fclose (ptr);
//fclose(ind);

//deallocating memory
  free2Dfloat (&X, MAXDATA, s);
  free1Dfloat (&buff, SIZE);
  free1Dint (&index, MAXDATA);


}
