<%@page import="java.sql.*"%>	
<%@page import="java.text.*"%>
<%@page import="java.util.*"%>


<HTML>
<TITLE>Your Shopping Basket</TITLE>


<%
	// Part 1: We retrieve and process all cookie
	// information right away so that our JSP will always
	// has this information on hand


	// Retrieve user and basket cookie data
 	Cookie[] cookies = request.getCookies();

	String basketCookie = "", username = "";

	if(cookies!=null) {
		for (int i=0; i<cookies.length; i++) {
			Cookie singleCookie = cookies[i];
			if(singleCookie.getName().equals("basket"))
				basketCookie=singleCookie.getValue();
			if(singleCookie.getName().equals("username"))
				username=singleCookie.getValue();
		}
	}

	// Set up login information
	boolean loggedIn = (!username.equals(""));
	
	// Convert the basket cookie data from a string to two arrays
	ArrayList items = new ArrayList(0);
	ArrayList qtys = new ArrayList(0);
	String tempWord="";
	char tempChar;

	// We reference elements in the basket cookie as:
	//   "ISBN1,Qty1:ISBN2,Qty2:ISBN3,Qty3: ... etc for however
	// many unique elements are in the cookie
	for(int i=0; i<basketCookie.length(); i++) {
		tempChar = basketCookie.charAt(i);
		if((tempChar==',')||(tempChar==':')) {
			if(tempChar==',')
				items.add(tempWord);
			else
				qtys.add(tempWord);
			tempWord="";
		}
		else
			tempWord += tempChar;
	}
%>


<%
	// Part 2: We setup some JavaScript functions our
	// form will need
%>

<HEAD><SCRIPT LANGUAGE="JavaScript">

	//
	// This function removes the built-in <submit form on
	// enter key pressed> for single text fields for
	// Inter Explorer 4.0 and up.  This function is needed
	// since we are using a JavaScript to prepare the data
	// prior to submission
	//
	function noenter() {
		return !(window.event && window.event.keyCode == 13);
	}


	//
	// JavaScript function that checks a quantity to make
	// sure that it is numeric and that it is between
	// 0 and 100 including 0 and 100
	//
	function qty_check(item) {
		var returnVal = false;
	
		if ((isNaN(item.value))||(!item.value))
			alert("Please enter a valid number.")
		else if (parseInt(item.value) < 0) 
			alert("Please enter a quantity greater than 0.")
		else if (parseInt(item.value) > 100) 
			alert("Please enter a quantity less than or equal to 100.")
		else 
			returnVal = true
	
		item.focus();
		return returnVal;
	}


	//
	// JavaScript function that converts all the form data
	// into a single cookie value string and stores this
	// new value on the computer
	//
	function prepare_data() {
		cookieValue="";

		// First, we generate the cookie string
<%
		// OurJSP dynamically creates the number of form elements to
		// take values from based on the number items originally loaded
		// from the basket cookie
		for(int i=0; i<items.size(); i++) {
			// 
			out.println("\t\tif(document.ShoppingBasket.qty"+i+".value>0) {");
				out.println("\t\t\tcookieValue+=document.ShoppingBasket.item"+i+".value+\",\"");
				out.println("\t\t\tcookieValue+=document.ShoppingBasket.qty"+i+".value+\":\"");
			out.println("\t\t}");
		}
%>

		// Then, we store the cookie on the user's computer
		document.cookie = "basket="+cookieValue+";";

		//	alert("Basket Updated!")

		// Finally, we invoke a form submit
		document.ShoppingBasket.submit();
	}
</SCRIPT></HEAD>

<BODY>
<script language="javascript" src="menu.js"></script>


<TABLE WIDTH=\"80%\" CELLPADDING="10" CELLSPACING="10" ALIGN="CENTER">
	<TR>
		<TD><H1>Shopping Basket</H1></td>
		<TD><IMG SRC="images\book5.jpg" WIDTH="128" HEIGHT="127"/></TD>
	</TR>
</TABLE>


<%
	// Part 3:  We display the form to the user based on the
	// information retrieved from the cookies


	// First, Display a message based on whether or not
	// the user is logged in
	if(loggedIn)
		out.println("<CENTER><TABLE WIDTH=\"65%\"><TR><TD>You are currently logged in as: <B>"+username+"</B></TD></TR></TABLE></CENTER>");
	else {
		out.println("<CENTER><TABLE WIDTH=\"65%\"><TR><TD>You are <B>not</B> currently logged in.</TD></TR>");
		out.println("<TR><TD>Please select <A HREF=\"login.jsp\">login</A> go sign on.</TD></TR></TABLE></CENTER>");
	}



	// Then we construct the From using retrieved cookie data
	Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
	try {

		// We need to connect to the database to retrieve
		// each book's name and price
		Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
		Statement stmt = con.createStatement();
		boolean basketEmpty = true;
		double totalCost = 0;
		NumberFormat n = NumberFormat.getCurrencyInstance(Locale.US);
		

		// For each unique book in the shopping basket
		boolean first=false;
		for(int i=0; i<items.size();i++) {

			// Retrieve book information from Database
			String sql = "SELECT isbn, title, price FROM Books WHERE ISBN = '"+items.get(i)+"'";
			ResultSet rs = stmt.executeQuery(sql);
			if(rs.next()) {

				// ***This code is only being generated if at least
				// one book is found in the database matching
				// a book in the user's shopping basket***


				// Update total cost of all books variable
				double cost = Double.parseDouble(rs.getString("price"))*Integer.parseInt((String)qtys.get(i));
				totalCost += cost;


				// On the first book found only, add some form header info
				if(!first) {
					first=true;
					basketEmpty = false;
					out.println("<FORM NAME=\"ShoppingBasket\" ACTION=\"basket.jsp\" METHOD=\"POST\">");
					out.println("<CENTER><TABLE WIDTH=\"65%\"><TR><TD>To delete at item from the shopping basket, set the quantity to zero.</TD></TR></TABLE></CENTER>");
					out.println("<CENTER><BR/><IMG SRC=\"images\\line2.jpg\"><BR/></CENTER>");
					out.println("<CENTER><TABLE WIDTH=\"62%\"><BR/>");
				}


				// Finally present this information to the user as a form
				out.println("<TR><TD><A HREF=\"/servlet/BookHome?ISBN="+rs.getString("isbn")+"\">"+rs.getString("title")+"</A></TD>");
				out.println("<INPUT TYPE = \"HIDDEN\" NAME=\"item"+i+"\" VALUE = \""+items.get(i)+"\">");
				out.println("<TD><INPUT TYPE = \"TEXT\" SIZE =\"3\" MAXLENGTH=\"3\" NAME=\"qty"+i+"\"");
				out.println("VALUE = \""+qtys.get(i)+"\" onChange=\"return qty_check(this)\" onkeypress=\"return noenter()\"></TD>");
				out.println("<TD> x </TD>");
				out.println("<TD ALIGN=\"RIGHT\">"+n.format(Double.parseDouble(rs.getString("price")))+"</TD>");
				out.println("<TD> = </TD>");
				out.println("<TD ALIGN=\"RIGHT\"> "+n.format(cost)+" </TD>");
				out.println("</TR>");
			}
			else {
				// This else is executed if a book was removed from
				// database since the user added it to their
				// shopping cart.  It updates the quantity value
				// of such a book to be 0
				qtys.set(i,"0");
				out.println("<INPUT TYPE = \"HIDDEN\" NAME=\"item"+i+"\" VALUE = \""+items.get(i)+"\">");
				out.println("<INPUT TYPE = \"HIDDEN\" NAME=\"qty"+i+"\" VALUE = \"0\">");
			}

			rs.close();
		}


		// If at least one book was found, add closing HTML code
		if(!basketEmpty) {
			out.println("</TABLE>");
			out.println("<BR/><IMG SRC=\"images\\line2.jpg\"><BR/><BR/>");
			out.println("<TABLE WIDTH=\"62%\"><TR>");
			out.println("<TD WIDTH=\"15%\"></TD>");
			out.println("<TD WIDTH=\"10%\" ALIGN=\"RIGHT\"><B>Total:</B></TD>");
			out.println("<TD WIDTH=\"4%\" ALIGN=\"RIGHT\">"+n.format(totalCost)+"</TD>");
			out.println("</TR></TABLE></CENTER>");
			out.println("<INPUT TYPE = \"HIDDEN\" NAME = \"Post\" VALUE = \"true\">");
			out.println("<CENTER><INPUT TYPE=\"BUTTON\" VALUE=\"Update\" onClick=\"prepare_data()\" onSubmit=\"false\"></CENTER>");
		}

		// Else, tell the user no books were found
		else
			out.println("<CENTER><TABLE WIDTH=\"65%\"><TR><TD>Your shopping cart is currently empty.</TD></TR></TABLE></CENTER>");

		// We always close our database connection instances
		stmt.close();
		con.close();
	}
	catch(Exception e) {
		out.println(e.toString());
	}

%>


</FORM>
</BODY>
<script language="javascript" src="footer.js"></script>
</HTML>