<%@page import="PurchaseData"%>


<jsp:useBean id="purchaseParams" class="PurchaseData">
	<jsp:setProperty name="purchaseParams"
	 property="ISBN"
	 param="ISBN"/>
</jsp:useBean>


<%
	// Part 1:  Fetch the basket cookie

	// We fetch the basket cookie if it exists
	String cookieValue="", newCookieValue="";
	Cookie[] cookies = request.getCookies();
	if(cookies!=null) {
		for (int i=0; i<cookies.length; i++) {
			Cookie basketCookie = cookies[i];
			if (basketCookie.getName().equals("basket"))
				cookieValue= basketCookie.getValue();
		}
	}


	// Part 2: Now we add/update this basket cookie value
	//  -There are 2 possible cases

	String ISBN = purchaseParams.getISBN();
	int location = cookieValue.indexOf(ISBN);
	long qty = 0;


	// Case 1 - Book does not exist in basket (basket may
	// be empty)
	if(location==-1)
		newCookieValue=cookieValue+ISBN+",1:";


	// Case 2 - Basket contains a copy of the book all ready,
	// so we construct a new cookie string with the quantity
	// of the book incremented by 1
	else {
		String head = cookieValue.substring(0,location);
		String tail = cookieValue.substring(cookieValue.indexOf(":",location)+1,cookieValue.length());

		try {
			qty = Long.parseLong(cookieValue.substring(cookieValue.indexOf(",",location)+1,
		  				cookieValue.indexOf(":",location)));
		} catch (NumberFormatException e) {
			out.println(e.toString());
		}

		qty++;
		newCookieValue=head+ISBN+","+qty+":"+tail;
	}

	// Check for overflow- We don't allow any cookie to have
	// quantity greater than 100, if so we display an error
	// and leave the basket cookie as it was
	if(qty>100)
		out.println("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL=overflow.html\">");
	else {
		// Finally, save the new cookie
		Cookie basketCookie = new Cookie("basket",newCookieValue);
		basketCookie.setMaxAge(-1);
		response.addCookie(basketCookie);

		// Then, redirect user to their shopping basket
		out.println("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL=basket.jsp\">");
	}
%>