<%@page import="CheckoutData"%>
<%@page import="java.sql.*"%>
<%@page import="java.text.*"%>
<%@page import="java.util.*"%>


<jsp:useBean id="checkoutParams" class="CheckoutData">
	<jsp:setProperty name="checkoutParams"
	 property="cid"
	 param="Cid"/>
	<jsp:setProperty name="checkoutParams"
	 property="username"
	 param="Username"/>
	<jsp:setProperty name="checkoutParams"
	 property="cname"
	 param="Cname"/>
	<jsp:setProperty name="checkoutParams"
	 property="address"
	 param="Address"/>
	<jsp:setProperty name="checkoutParams"
	 property="basket"
	 param="Basket"/>
	<jsp:setProperty name="checkoutParams"
	 property="card1"
	 param="Card1"/>
	<jsp:setProperty name="checkoutParams"
	 property="card2"
	 param="Card2"/>
	<jsp:setProperty name="checkoutParams"
	 property="card3"
	 param="Card3"/>
	<jsp:setProperty name="checkoutParams"
	 property="card4"
	 param="Card4"/>
	<jsp:setProperty name="checkoutParams"
	 property="card_month"
	 param="Card_month"/>
	<jsp:setProperty name="checkoutParams"
	 property="card_year"
	 param="Card_year"/>
	<jsp:setProperty name="checkoutParams"
	 property="retry"
	 param="Retry"/>
</jsp:useBean>


<%!
	// Part 1: Setup JSP functions


	//
	// isNumericString() returns true iff the string input
	// supplied is a long number
	//
	public static boolean isNumericString(String input) {
		// We make sure to catch exceptions in the case
		// that the string is not a long number
		try {
			Long.parseLong(input);
			return(true);
		} catch (NumberFormatException e) {
			return(false);
		}
	}
%>


<%
	// Part 2: Retrieve Form Data from previous Form


	// Retrieve user and basket cookie data
	String cid = checkoutParams.getCid(), 
		username = checkoutParams.getUsername(),
		basket = checkoutParams.getBasket(),
		cname = checkoutParams.getCname(), address = checkoutParams.getAddress(),
		card1 = checkoutParams.getCard1(), card2 = checkoutParams.getCard2(),
		card3 = checkoutParams.getCard3(), card4 = checkoutParams.getCard4(),
		card_month = checkoutParams.getCard_month(),
		card_year = checkoutParams.getCard_year(),
		cardNumError = "", cardDateError = "";
	boolean anyError=false;


	// Part 3:  2 Possible Paths-
	//	 Part 3A: If it is the user's first
	//                 time accessing this page
	//     Part 3B: If the user has previously
	//                 submitted credit card info
	//                 on this page

	if(!cid.equals("")) {

		// Part 3A: If this is our first time accessing this
		// page we retrieve the user's full name and address
		// from the database

		if(!checkoutParams.retry()) {
			// We make a connection to the database			
			Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
			try {
				Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
				Statement stmt = con.createStatement();
				String sql = "SELECT cname, address FROM Customers WHERE cid = " + cid;
				ResultSet rs = stmt.executeQuery(sql);

				// Since the username is a primary key, we just
				// take the first record found
				if(rs.next()) {
					cname = rs.getString("cname");
					address = rs.getString("address");
				}

				// We always close our database connection instances
				rs.close();
				stmt.close();
				con.close();
			} catch(Exception e) {
				out.println(e.toString());
			}
		}

		// Part 3B: If this is not the user's first time
		// accessing this page, we all ready have their name
		// and address so we proceed to verifying that the
		// credit card information they provided is accurate.
		//
		// We recommend the reader review Part 4 before
		// Part 3B
		//

		else{
			// First, we check the card number
			if((card1.length()!=4)||(card2.length()!=4)
			   ||(card3.length()!=4)||(card4.length()!=4)) {
				anyError = true;	
				cardNumError = "* Please Enter entire credit card number";
			}
			else if((!isNumericString(card1))||(!isNumericString(card2))
				 ||(!isNumericString(card3))||(!isNumericString(card4))) {
				anyError = true;
				cardNumError = "* Please Re-Enter credit card number";
			}

			// Then we check the card date, reporting the first
			// error we find
			if(card_month.length()<1) {
				anyError = true;	
				cardDateError = "* Please enter expiration month";
			}
			else if(card_year.length()!=2) {
				anyError = true;	
				cardDateError = "* Please enter the 2-digit expiration year";
			}
				// Check that the month and year are valid numbers
			else if(!isNumericString(card_month)) {
				anyError = true;
				cardDateError = "* Please Re-Enter the month";
			}
			else if(!isNumericString(card_year)) {
				anyError = true;
				cardDateError = "* Please Re-Enter the year";
			}

			else {
				// Finally, check that the month is a
				// number from 1 to 12
				long month = Long.parseLong(card_month);
				if((month<1)||(month>12)) {
					anyError = true;
					cardDateError = "* Please choose a valid month";
				}
				// If the month is a under 10, format the
				// output to have 2 digits
				else if((month<10)&&(card_month.length()==1))
					card_month = "0"+card_month;
			}

		}
		
		// Part 4A: If this is the user's first time with
		// the form, or there is any error, re-create the form
		// for the user with all previous values displayed

		if((!checkoutParams.retry())||anyError) {

			// Display the HTML page header
			out.println("<HTML>");
			out.println("<TITLE>Step 2 - Verify Shipping Information</TITLE>");
			out.println("<script language=\"JavaScript\">");
			out.println("	function KeyPress(what,e,max,action) {");
			out.println("		if (document.layers) {");
			out.println("			if (e.target.value.length >= max)");
			out.println("				eval(action);");
			out.println("		} else if (document.all) {");
			out.println("			if (what.value.length > (max-1))");
			out.println("				eval(action);");
			out.println("		}");
			out.println("	}");
			out.println("</script>");
			out.println("<BODY>");
			out.println("<script language=\"javascript\" src=\"menu.js\"></script>");

			// Welcome user to the system
			out.println("<TABLE ALIGN =\"CENTER\" WIDTH=\"80%\"><TR><TD><H2>Step 2 - Verify Shipping Information</H2></TD></TR></TABLE>");
			out.println("<TABLE ALIGN =\"CENTER\" WIDTH=\"65%\"><TR><TD>Welcome, <B>"+username+"</B></TD></TR></TABLE>");
			out.println("<TABLE ALIGN =\"CENTER\" WIDTH=\"55%\"><TR><TD WIDTH=\"50%\">The order will be shipped to:</TD><TD><B>"+cname+"</B></TD></TR>");
			out.println("<TR><TD></TD><TD><B>"+address+"</B></TD></TR></TABLE><BR/>");
			out.println("<CENTER><BR/><IMG SRC=\"images\\line2.jpg\"><BR/><BR/></CENTER>");
	
			// Display the Form
			out.println("<BR/><TABLE ALIGN=\"CENTER\" WIDTH=\"80%\"><TR><TD><H2>Step 3 - Billing Information:</H2></TD></TR></TABLE>");
			out.println("<FORM NAME=\"CheckoutCont\" ACTION=\"checkoutcont.jsp\" METHOD=\"POST\">");
			out.println("<TABLE ALIGN=\"CENTER\" WIDTH=\"55%\"><TR><TD>Please enter your credit card number:</TD></TR></TABLE>");
			out.println("<TABLE ALIGN=\"CENTER\" WIDTH=\"55%\"><TR>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"4\" MAXLENGTH=\"4\" NAME=\"Card1\" VALUE=\""+card1+"\" onKeyPress=\"KeyPress(this,event,4,' document.CheckoutCont.Card2.focus()')\"></TD><TD ALIGN = \"CENTER\" WIDTH=\"0\">-</TD>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"4\" MAXLENGTH=\"4\" NAME=\"Card2\" VALUE=\""+card2+"\" onKeyPress=\"KeyPress(this,event,4,' document.CheckoutCont.Card3.focus()')\"></TD><TD ALIGN = \"CENTER\" WIDTH=\"0\">-</TD>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"4\" MAXLENGTH=\"4\" NAME=\"Card3\" VALUE=\""+card3+"\" onKeyPress=\"KeyPress(this,event,4,' document.CheckoutCont.Card4.focus()')\"></TD><TD ALIGN = \"CENTER\" WIDTH=\"0\">-</TD>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"4\" MAXLENGTH=\"4\" NAME=\"Card4\" VALUE=\""+card4+"\" onKeyPress=\"KeyPress(this,event,4,' document.CheckoutCont.Card_month.focus()')\"></TD WIDTH=\"0%\">");
			out.println("<TD WIDTH=\"2%\"></TD><TD WIDTH=\"100%\"><font color=ff0000>"+cardNumError+"</font></TD>");
			out.println("</TR></TABLE><BR/>");
			out.println("<TABLE ALIGN=\"CENTER\" WIDTH=\"55%\"><TR><TD WIDTH=\"40%\">Date (month/year): </TD>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"2\" MAXLENGTH=\"2\" NAME=\"Card_month\" VALUE=\""+card_month+"\" onKeyPress=\"KeyPress(this,event,2,' document.CheckoutCont.Card_year.focus()')\"></TD><TD ALIGN = \"CENTER\" WIDTH=\"0\">-</TD>");
			out.println("<TD ALIGN = \"CENTER\" WIDTH=\"0\"><INPUT TYPE=\"TEXT\" SIZE=\"2\" MAXLENGTH=\"2\" NAME=\"Card_year\" VALUE=\""+card_year+"\" onKeyPress=\"KeyPress(this,event,2,' document.CheckoutCont.Continue.focus()')\"></TD WIDTH=\"0%\">");
			out.println("<TD WIDTH=\"2%\"></TD><TD WIDTH=\"100%\"><font color=ff0000>"+cardDateError+"</font></TD>");
			out.println("</TR></TABLE><BR/>");

			// Save Hidden Form Information
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Cid\" VALUE=\""+cid+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Username\" VALUE=\""+username+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Cname\" VALUE=\""+cname+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Address\" VALUE=\""+address+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Basket\" VALUE=\""+basket+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Retry\" VALUE=\"true\">");
			out.println("<CENTER><INPUT TYPE=\"SUBMIT\" NAME=\"Continue\" VALUE=\"Continue\"></CENTER>");
			out.println("</FORM>");
	
			// Display the HTML page tail
			out.println("</BODY>");
			out.println("<script language=\"javascript\" src=\"footer.js\"></script>");
			out.println("</HTML>");
		}

		// Part 4B:  Performed when the application server has
		// approved all the provided information.  We can now
		// proceed to the next page
		else {
			// Display the HTML page header	
			out.println("<HTML>");

			// Force a submit on load to proceed to the next page
			out.println("<BODY onload=\"document.CheckoutNext.submit()\">");

			// Save Hidden Form Information
			out.println("<FORM NAME=\"CheckoutNext\" ACTION=\"confirmorder.jsp\" METHOD=\"POST\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Cid\" VALUE=\""+cid+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Username\" VALUE=\""+username+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Cname\" VALUE=\""+cname+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Address\" VALUE=\""+address+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Basket\" VALUE=\""+basket+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Retry\" VALUE=\"true\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card1\" VALUE=\""+card1+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card2\" VALUE=\""+card2+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card3\" VALUE=\""+card3+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card4\" VALUE=\""+card4+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card_month\" VALUE=\""+card_month+"\">");
			out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"Card_year\" VALUE=\""+card_year+"\">");

			// Display the HTML page tail
			out.println("</FORM>");
			out.println("</BODY>");
			out.println("</HTML>");
		}
	}

	// Part 5: If user attempts to access this JSP outside
	// the context of a form session, we display an error

	else
		out.println("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL=expiredform.html\">");
%>