<%@page import="BookInfo"%>
<%@page import="java.sql.*"%>
<%@page import="java.text.*"%>
<%@page import="java.util.*"%>


<jsp:useBean id="bookParams" class="BookInfo">
  <jsp:setProperty name="bookParams"
    property="ISBN"
    param="ISBN"/>
  <jsp:setProperty name="bookParams"
    property="title"
    param="Title"/>
  <jsp:setProperty name="bookParams"
    property="author"
    param="Author"/>
  <jsp:setProperty name="bookParams"
    property="qty"
    param="Qty"/>
  <jsp:setProperty name="bookParams"
    property="price"
    param="Price"/>
  <jsp:setProperty name="bookParams"
    property="year"
    param="Year"/>
  <jsp:setProperty name="bookParams"
    property="retry"
    param="Retry"/>
</jsp:useBean>


<%!
	// Part 1: Setup JSP functions

	//
	// ReplaceQuote converts all single quotes to two single quotes.
	// Since single quotes are reserved characters in the database, 
      // we need this function in order to convert data that could
	// conceivably contain single quotes to an appropriate format
	// that the database will read.
	//
	public String replaceQuote(String input) {
		String temp="";
		for(int i=0; i<input.length(); i++)
			if(input.charAt(i)=='\'')
				temp += "''";
			else
				temp += input.charAt(i);
		return temp;
	}


	//
	// isNumericString() returns true iff the string input
	// supplied is a long number
	//
	public static boolean isNumericString(String input) {
		// We make sure to catch exceptions in the case
		// that the string is not a long number
		try {
			Long.parseLong(input);
			return(true);
		} catch (NumberFormatException e) {
			return(false);
		}
	}


	//
	// checkPrice() returns true iff the string input
	// supplied is NOT valid American dollar value
	//
	public boolean checkPrice(String input) {
		try {
			NumberFormat num = NumberFormat.getInstance();
			num.setMaximumFractionDigits(2);
			num.setMinimumFractionDigits(2);
			num.setGroupingUsed(false);

			double amt = Double.parseDouble(input);

			if (Double.parseDouble(num.format(amt)) == amt)
				return false;
			else 
				return true;
		} catch (NumberFormatException e) {
			return true;
		}
	}


	//
	// This function returns true iff the ISBN provided all
	// ready exists in the database for another book
	//
	public boolean checkDuplicateISBN(String input) {
		boolean toReturn = true;
		
		// Open database connection
		try {
			Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
			Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
			Statement stmt= con.createStatement();
			String bookSQL= "SELECT isbn, title FROM Books WHERE ISBN = '" + input +"'";

			ResultSet rs = stmt.executeQuery(bookSQL);

			// If the book already exists in the database, the first
			// call to rs.next() will be true
			toReturn = rs.next();

			// We always close our database connection instances
			rs.close();
			stmt.close();
			con.close();
		} catch (Exception e) {
			// On any errors, we just return true
			return(true);
		}
		return toReturn;
	}


	//
	// This function returns true iff the name provideded is
	// NOT in an appropriate format for our database
	//
	public boolean checkName(String input) {
		char[] in = input.toLowerCase().toCharArray();
		// We check the string for the existence of
		// invalid special characters
		for (int i=0; i<in.length; i++) {
			if(Character.isLetterOrDigit(in[i]))
				return false;
		}
		return true;
	}


	//
	// This function returns true iff the name provideded is
	// NOT in an appropriate format for our database
	//
	public boolean checkTitle(String input) {
		char[] in = input.toLowerCase().toCharArray();
		// We check the string for the existence of
		// invalid special characters
		for (int i=0; i<in.length; i++) {
			if(Character.isLetterOrDigit(in[i]))
				return(false);
		}
		return(true);
	}
%>


<%
	// Part 2: To be done after a post to this page.
	//    Specifically, this part is actually done 2nd
	// to verify new book information, after a user has
	// provided it on the previous submission.
	//
	// We recommend the reader review Part 3A before Part 2
	//

	// We first need to initialize a number of variables
	boolean anyError = false;  // anyError set true if any error occurs
	String is="", ti="", au="", qt="", ye="", pr="";

	// These variables record particular types of errors
 	String ISBNError="", titleError="", authorError="", qtyError="",
		priceError="", yearError="";

	// Only proceed if user has previously posted data
	if (bookParams.Retry()) {

		// First, check that the ISBN number is valid
		// and no book exists with this number all ready
		// in the database
		is = bookParams.getISBN();
		if (is.length() != 10) {
			ISBNError="* ISBN must be exactly 10 characters long";
			anyError = true;
		} else if (!isNumericString(is)) {
			ISBNError="* ISBN must only contain numbers";
			anyError = true;
		} else if(checkDuplicateISBN(is)) {
			ISBNError="* A book with this ISBN number already exists in the database";
			anyError = true;
		}


		// Next, check to make sure the title is properly
		// formatted and of the right size
		ti = bookParams.getTitle();
		if (ti.length() == 0) {
			titleError= "* You must enter a title";
			anyError = true;
		} else if(ti.length() > 50) {
			titleError= "* We're sorry, that title is too long.  Please truncate it to 50 characters";
			anyError = true;
		} else if(checkTitle(ti)) {
			titleError= "* Invalid title";
			anyError = true;
		}

		// Then, check to make sure the author's name is
		// properly formatted and of the right size
		au = bookParams.getAuthor();
		if (au.length() == 0) {
			authorError= "* You must enter an author";
			anyError = true;
		} else if (au.length() > 50) {
			authorError= "* We're sorry, that name is too long.  Please truncate it to 50 characters";
			anyError = true;
		} else if(checkName(au)) {
			authorError= "* Invalid name";
			anyError= true;
		}

		// We then check that the quantity is a number and
		// of a value such that:  0 <= qty <= 10,000
		qt = bookParams.getQty();
		if (qt.length() == 0) {
			qtyError= "* You must enter a quantity value";
			anyError = true;
		} else if(!isNumericString(qt)) {
			qtyError= "* Invalid quantity";
			anyError = true;
		} else {			
			long qt_val = Long.parseLong(qt);
			if(qt_val<0) {
				qtyError= "* Quantity must be a non-negative integer";
				anyError = true;
			} else if(qt_val>10000) {
				qtyError= "* Quantity must be less than 10,000";
				anyError = true;
			}
		}
		
		// We next verify that the price has been
		// entered correctly
		pr = bookParams.getPrice();
		if (pr.length() == 0) {
			priceError = "* You must enter a price";
			anyError=true;
		} else if(checkPrice(pr)) {
			priceError = "* Invalid book price";
			anyError = true;
		}

		// Finally, we check the value of year
		ye = bookParams.getYear();
		if (ye.length() == 0) {
			yearError= "* You must enter a publishing year";
			anyError = true;
		} else if(ye.length() != 4) {
			yearError= "* Please enter a 4-digit Year";
			anyError = true;
		} else if(!isNumericString(ye)) {
			yearError= "* Invalid Year";
			anyError = true;
		}	}

	// Part 3A: If this is the user's first time with the form,
   	// or there is any error, re-create the form for the user with
	// all previous values displayed

	if (anyError || !bookParams.Retry()) {

		// Display the HTML page header
		out.println("<HTML>");
		out.println("<TITLE>Add a New Book to The Internet BookShop</TITLE>");
		out.println("<script language=\"JavaScript\">");
		out.println("	function KeyPress(what,e,max,action) {");
		out.println("		if (document.layers) {");
		out.println("			if (e.target.value.length >= max)");
		out.println("				eval(action);");
		out.println("		} else if (document.all) {");
		out.println("			if (what.value.length > (max-1))");
		out.println("				eval(action);");
		out.println("		}");
		out.println("	}");
		out.println("</script>");
		out.println("<BODY>");
		out.println("<script language=\"javascript\" src=\"menu.js\"></script>");
		out.println("<CENTER><H1>Add a new Book</H1></CENTER>");

		// Display the Form
		out.println("<FORM NAME = \"NewBookInfo\" ACTION = \"newbook.jsp\" METHOD = \"POST\">");
		out.println("<h2>Book Information</h2>");
		out.println("<table>");
		out.println("<TR><TD width=300>ISBN Number:</TD><TD><INPUT TYPE=TEXT NAME=ISBN SIZE=10 MAXLENGTH=10 VALUE=\"" + is + "\" onKeyPress=\"KeyPress(this,event,10,' document.NewBookInfo.Title.focus()')\"></TD><TD><font color=ff0000>" + ISBNError + "</TD></TR>");
		out.println("<TR><TD width=300>Title:</TD><TD><INPUT TYPE=TEXT NAME=Title SIZE=20 MAXLENGTH=50 VALUE=\"" + ti + "\"></TD><TD><font color=ff0000>" + titleError + "</TD></TR>");
		out.println("<TR><TD width=300>Author:</TD><TD><INPUT TYPE=TEXT NAME=Author SIZE=20 MAXLENGTH=50 VALUE=\"" + au + "\"></TD><TD><font color=ff0000>" + authorError + "</font></TD></TR>");
		out.println("<TR><TD width=300>Publishing Year (4 digit):</TD><TD><INPUT TYPE=TEXT NAME=Year SIZE=4 MAXLENGTH=4 VALUE=\"" + ye + "\" onKeyPress=\"KeyPress(this,event,4,' document.NewBookInfo.Price.focus()')\"></TD><TD><font color=ff0000>" + yearError + "</font></TD></TR>");
		out.println("</table>");
		out.println("<BR/>");
		out.println("<hr>");
		out.println("<BR/>");
		out.println("<h2>BookStore Information</h2>");
		out.println("<table>");
		out.println("<TR><TD width=300>Price:</TD><TD>$</TD><TD><INPUT TYPE=TEXT NAME=Price SIZE=5  MAXLENGTH=10 VALUE=\"" + pr + "\"></TD><TD><font color=ff0000>" + priceError + "</font></TD></TR>");
		out.println("<TR><TD width=300>Quantity:</TD><TD></TD><TD><INPUT TYPE=TEXT NAME=Qty SIZE=5  MAXLENGTH=5 VALUE=\"" + qt + "\"></TD><TD><font color=ff0000>" + qtyError + "</font></TD></TR>");
		out.println("</TABLE>");
		out.println("<BR/>");
		out.println("<HR>");
		out.println("<BR/>");
		out.println("<CENTER><INPUT TYPE=SUBMIT VALUE=\"Add New Book!\"></CENTER>");
		out.println("		<INPUT TYPE = \"HIDDEN\" NAME = \"Retry\" VALUE = \"true\">");
		out.println("</form>");

		// Display the HTML page tail
		out.println("</BODY>");
		out.println("<script language=\"javascript\" src=\"footer.js\"></script>");
		out.println("</HTML>");
	}

	// Part 3B:  Performed when the application server has
	// approved all the provided information.  We can now
	// insert this data into the database and take the user
	// to the new book's home page
	else {
		// First, connect to the database
		Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
		try {
			Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
			Statement stmt = con.createStatement();
			String insertSQL = "";

			// Next Construct the appropriate SQL insert statement	
			insertSQL = "INSERT INTO Books (ISBN,title,author,qty_in_stock,price,year_published) VALUES ("
				+"'"+bookParams.getISBN()+"',"
				+"'"+replaceQuote(bookParams.getTitle())+"',"
				+"'"+replaceQuote(bookParams.getAuthor()) + "',"
				+bookParams.getQty() + ","
				+bookParams.getPrice() + ","
				+bookParams.getYear() + ")";

			// Then, Perform the insert
			int r = stmt.executeUpdate(insertSQL);

			// We always close our database connection instances
			stmt.close();
			con.close();

			// We must verify that the insert was successful
			if (r != 1)
				out.println("Database Book Insertion Error, Please try Again Later");

			// If the account was created successfully, then we re-use
			// the form of the login.jsp to immediately log the user
			// in and take them to their shopping basket
			else
				out.println("<META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL=/servlet/BookHome?ISBN="+bookParams.getISBN()+"\">");
		} catch (Exception e) {
			out.println("Database Book Insertion Error, Please try Again Later");
		}
	}
%>