<%@page import="UserInfo"%>
<%@page import="java.sql.*"%>
<%@page import="java.text.*"%>
<%@page import="java.util.*"%>


<jsp:useBean id="userParams" class="UserInfo">
  <jsp:setProperty name="userParams"
    property="username"
    param="Username"/>
  <jsp:setProperty name="userParams"
    property="pass1"
    param="Password1"/>
  <jsp:setProperty name="userParams"
    property="pass2"
    param="Password2"/>
  <jsp:setProperty name="userParams"
    property="custName"
    param="CustName"/>
  <jsp:setProperty name="userParams"
    property="address"
    param="Address"/>
  <jsp:setProperty name="userParams"
    property="retry"
    param="Retry"/>
</jsp:useBean>


<%!
	// Part 1: Setup JSP functions


	//
	// ReplaceQuote converts all single quotes to two single quotes.
	// Since single quotes are reserved characters in the database, 
      // we need this function in order to convert data that could
	// conceivably contain single quotes to an appropriate format
	// that the database will read.
	//
	public String replaceQuote(String input) {
		String temp="";
		for(int i=0; i<input.length(); i++)
			if(input.charAt(i)=='\'')
				temp += "''";
			else
				temp += input.charAt(i);
		return temp;
	}


	//
	// This function returns true iff string contains special
	// keyboard characters
	//
	public boolean checkSpecialChar(String input) {
		char[] in = input.toLowerCase().toCharArray();
		for (int i=0; i<in.length; i++) {
			if (!((in[i] > 47 && in[i] < 58) || in[i] == 95 || (in[i] > 96 && in[i] < 123)))
				return true;
		}
		return false;
	}


	//
	// This function returns true iff username provided all
	// ready exists in the database
	//
	public boolean checkDuplicateUserName(String input) {
		boolean toReturn = true;
		
		// Open database connection
		try {
			Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
			Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
			Statement stmt= con.createStatement();
			String usernameSQL= "SELECT username, password FROM Customers WHERE lower(USERNAME) = '" + input.toLowerCase() +"'";

			ResultSet rs = stmt.executeQuery(usernameSQL);

			// If username exists in the database, the first call to
			// rs.next() will be true
			toReturn = rs.next();

			// We always close our database connection instances
			rs.close();
			stmt.close();
			con.close();
		} catch (Exception e) {
			// On any errors, we just return true
			return(true);
		}
		return toReturn;
	}


	//
	// This function returns true iff the name provideded is
	// NOT in an appropriate format for our database
	//
	public boolean checkName(String input) {
		char[] in = input.toLowerCase().toCharArray();
		// We check the string for the existence of
		// invalid special characters
		for (int i=0; i<in.length; i++) {
			if(Character.isLetterOrDigit(in[i]))
				return false;
		}
		return true;
	}


	//
	// This function returns true iff the address provided is
	// NOT in an appropriate format for our database
	//
	public boolean checkAddress(String input) {
		char[] in = input.toLowerCase().toCharArray();
		// We check the string for the existence of
		// invalid special characters
		for (int i=0; i<in.length; i++) {
			if (!(in[i] == 32 || in[i] == 35 || in[i] == 39 || in[i] == 44 || in[i] == 45 || in[i] == 46 || (in[i] > 47 && in[i] < 58) || in[i] == 95 || (in[i] > 96 && in[i] < 123)))
				return true;
		}
		return false;
	}
%>


<%
	// Part 2: To be done after a post to this page.
	//    Specifically, this part is actually done 2nd
	// to verify new user information, after a user has
	// provided it on the previous submission.
	//
	// We recommend the reader review Part 3A before Part 2
	//

	// We first need to initialize a number of variables
	boolean anyError = false;  // anyError set true if any error occurs
	String un="", p1="", p2="", cn="", ad="";

	// These variables record particular types of errors
 	String usernameError="", passwordError="", custNameError="", addressError="";

	// Only proceed if user has previously posted data
	if (userParams.Retry()) {

		// First, check the username carefully
		un = userParams.getUsername();

		if (un.length() < 4) {
			usernameError="* Usernames must be at least 4 characters long";
			anyError = true;
		} else if (un.length() > 15) {
			usernameError="* Usernames must be less than 16 characters long";
			anyError = true;
		} else if(checkSpecialChar(un)) {
			usernameError="* Usernames cannot contain spaces or other special characters (except the underscore)";
			anyError = true;
		} else if(checkDuplicateUserName(un)) {
			usernameError="* There is already a user with that username";
			anyError = true;
		}

		// Then, check that the 2 passwords match and are of an
		// appropriate size
		p1 = userParams.getPass1();
		p2 = userParams.getPass2();
		if (!p1.equals(p2)) {
			passwordError="* Passwords did not match";
			anyError = true;
		} else if (p1.length() < 4) {
			passwordError="* Passwords must be at least 4 characters long";
			anyError = true;
		} else if(p1.length() > 10) {
			passwordError="* Passwords must be less than 11 characters long";
			anyError = true;
		}

		// Then, check the format of the customer's name
		cn = userParams.getCustName();
		if (cn.length() == 0) {
			custNameError = "* You must enter a name";
			anyError = true;
		} else if(cn.length() > 30) {
			custNameError = "* We're sorry, your last name is too long.  Please truncate it to 30 characters";
			anyError = true;
		} else if(checkName(cn)) {
			custNameError = "* Invalid last name";
			anyError = true;
		} 

		// Finally, check the format of the customer's address
		ad = userParams.getAddress();
		if (ad.length() == 0) {
			addressError = "* You must enter an address";
			anyError=true;
		} else if (ad.length() > 100) {
			addressError = "* Addresses must be less than 100 characters";
			anyError = true;	
		} else if(checkAddress(ad)) {
			addressError = "* Invalid address";
			anyError = true;
		}
	}

	// Part 3A: If this is the user's first time with the form,
   	// or there is any error, re-create the form for the user with
	// all previous values displayed (except the passwords)

	if (anyError || !userParams.Retry()) {

		// Display the HTML page header
		out.println("<HTML>");
		out.println("<TITLE>Create a New Account on The Internet BookShop</TITLE>");
		out.println("<BODY>");
		out.println("<script language=\"javascript\" src=\"menu.js\"></script>");
		out.println("<CENTER><H1>Create an Account</H1></CENTER>");
		out.println("Create an Account in 3 Easy Steps:<BR/>");
		out.println("<BLOCKQUOTE>1)  Choose a user name and password<BR/>");
		out.println("2)  Tell us about yourself<BR/>");
		out.println("3)  Provide us with a Shipping Address for your Orders<BR/>");
		out.println("</BLOCKQUOTE><hr><BR/>");	


		// Display the Form
		out.println("<FORM NAME = \"NewUserInfo\" ACTION = \"newuser.jsp\" METHOD = \"POST\">");
		out.println("<H2>User Information</H2>");
		out.println("<TABLE>");
		out.println("<TR><TD width=300>User Name:</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"Username\" SIZE=\"15\" MAXLENGTH=\"15\" VALUE=\"" + un + "\"></TD><TD><font color=ff0000>" + usernameError + "</TD></TR>");
		out.println("<TR><TD width=300>Password:</TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"Password1\" SIZE=\"15\" MAXLENGTH=\"10\"></TD><TD><font color=ff0000>" + passwordError + "</font></TD></TR>");
		out.println("<TR><TD width=300>Confirm Password:</TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"Password2\" SIZE=\"15\" MAXLENGTH=\"10\"></TD></TR>");
		out.println("</TABLE>");
		out.println("<BR/>");
		out.println("<hr>");
		out.println("<BR/>");
		out.println("<H2>Personal Information</H2>");
		out.println("<TABLE>");
		out.println("<TR><TD width=300>Full Name:</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"CustName\" SIZE=\"15\"  MAXLENGTH=\"30\" VALUE=\"" + cn + "\"></TD><TD><font color=ff0000>" + custNameError + "</font></TD></TR>");
		out.println("</TABLE>");
		out.println("<BR/>");
		out.println("<HR>");
		out.println("<BR/>");
		out.println("<H2>Contact Information</H2>");
		out.println("<TABLE>");
		out.println("<TR><TD width=300>Shipping Address:</TD><TD><INPUT TYPE=\"TEXT\" NAME=\"Address\" SIZE=\"15\"  MAXLENGTH=\"100\" VALUE=\"" + ad + "\"></TD><TD><font color=ff0000>" + addressError + "</font></TD></TR>");
		out.println("</TABLE><BR/>");
		out.println("<CENTER><INPUT TYPE=SUBMIT VALUE=\"Create Account\"></CENTER>");
		out.println("		<INPUT TYPE = \"HIDDEN\" NAME = \"Retry\" VALUE = \"true\">");
		out.println("</form>");


		// Display the HTML page tail
		out.println("</BODY>");
		out.println("<script language=\"javascript\" src=\"footer.js\"></script>");
		out.println("</HTML>");
	}

	// Part 3B:  Performed when the application server has
	// approved all the provided information.  We can now
	// insert this data into the database and log the
	// user in
	else {
		// First, connect to the database
		Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
		try {
			Connection con = DriverManager.getConnection("jdbc:microsoft:sqlserver://ServerName:1433;databasename=bookshop","user","pass");
			Statement stmt = con.createStatement();
			String insertSQL = "";

			// Next Construct the appropriate SQL insert statement	
			insertSQL = "INSERT INTO Customers (cname,address,username,password) VALUES ("
				+"'" + replaceQuote(userParams.getCustName()) + "','"
				+replaceQuote(userParams.getAddress()) + "','"
				+userParams.getUsername() + "','" + userParams.getPass1() + "')";

			// Then, Perform the insert
			int r = stmt.executeUpdate(insertSQL);

			// We always close our database connection instances
			stmt.close();
			con.close();

			// We must verify that the insert was successful
			if (r != 1)
				out.println("Database User Insertion Error, Please try Again Later");

			// If the user was successfully added to the database,
			// then we redirect the user's shopping basket
			else {
				out.println("<BODY onload=\"document.Login.submit()\">");
				out.println("<FORM NAME = \"Login\" METHOD = \"POST\" ACTION=\"login.jsp\">");
				out.println("\t<INPUT TYPE = \"HIDDEN\" NAME = \"Username\" SIZE=\"20\" MAXLENGTH=\"20\" VALUE = \""+userParams.getUsername()+"\">");
				out.println("\t<INPUT TYPE = \"HIDDEN\" NAME = \"Password\" SIZE=\"20\" MAXLENGTH=\"20\" VALUE = \""+userParams.getPass1()+"\">");
				out.println("\t<INPUT TYPE = \"HIDDEN\" NAME = \"Retry\" VALUE=\"true\">");
				out.println("</FORM>");
				out.println("</BODY>");
			}
		} catch (Exception e) {
			out.println("Database User Insertion Error, Please try Again Later");
		}
	}
%>